//=============================================================================
// PersonaSkillButtonWindow
//=============================================================================

class IndiePartWindow extends PersonaBorderButtonWindow;

var Window                  winIcon;
var PersonaSkillTextWindow  winName;
var CraftingPart Part;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	SetWidth(220);

	CreateControls();
}

// ----------------------------------------------------------------------
// CreateControls()
// ----------------------------------------------------------------------

function CreateControls()
{
	winIcon = NewChild(Class'Window');
	winIcon.SetBackgroundStyle(DSTY_Masked);
	winIcon.SetPos(18, 1);
	winIcon.SetSize(48, 48);
	
	winName = PersonaSkillTextWindow(NewChild(Class'PersonaSkillTextWindow'));
	winName.SetPos(68, 0);
	winName.SetSize(308, 27);
	winName.SetFont(Font'FontMenuHeaders');
}

// ----------------------------------------------------------------------
// SelectButton()
// ----------------------------------------------------------------------

/*function SelectButton(Bool bNewSelected)
{
	bSelected = bNewSelected;

	// Update text colors 
	winName.SetSelected(bSelected);
}*/

// ----------------------------------------------------------------------
// SetButtonMetrics()
//
// Calculates which set of textures we're going to use as well as 
// any text offset (used if the button is pressed in)
// ----------------------------------------------------------------------

/*function SetButtonMetrics()
{
	if (bIsSensitive)
	{
		if (bSelected)				
		{
			textureIndex = 1;
			textColorIndex = 2;
		}
		else
		{
			textureIndex = 0;
			textColorIndex = 0;
		}
	}
	else								// disabled
	{
		textureIndex = 0;
		textColorIndex = 3;
	}
}	*/

// ----------------------------------------------------------------------
// SetSkill()
// ----------------------------------------------------------------------

function SetPart(CraftingPart newPart)
{
	Part = newPart;

	RefreshPartInfo();
}

// ----------------------------------------------------------------------
// GetSkill()
// ----------------------------------------------------------------------

/*function Skill GetSkill()
{
	return skill;
}*/

// ----------------------------------------------------------------------
// RefreshSkillInfo()
// ----------------------------------------------------------------------

function RefreshPartInfo()
{
	local string Copies;

	if (Part != None)
	{
		if (Part.NumCopies > 1) Copies = " ("$Part.NumCopies$")";
		
		winIcon.SetBackground(Part.LargeIcon);
		winName.SetText(Part.ItemName$Copies@Part.GetDurability()$CR()$Part.GetStats());
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     Left_Textures(0)=(Tex=Texture'DeusExUI.UserInterface.PersonaSkillsButtonNormal_Left',Width=4)
     Left_Textures(1)=(Tex=Texture'DeusExUI.UserInterface.PersonaSkillsButtonFocus_Left',Width=4)
     Right_Textures(0)=(Tex=Texture'DeusExUI.UserInterface.PersonaSkillsButtonNormal_Right',Width=8)
     Right_Textures(1)=(Tex=Texture'DeusExUI.UserInterface.PersonaSkillsButtonFocus_Right',Width=8)
     Center_Textures(0)=(Tex=Texture'DeusExUI.UserInterface.PersonaSkillsButtonNormal_Center',Width=4)
     Center_Textures(1)=(Tex=Texture'DeusExUI.UserInterface.PersonaSkillsButtonFocus_Center',Width=4)
     fontButtonText=Font'DeusExUI.FontMenuTitle'
     buttonHeight=27
     minimumButtonWidth=50
}
